<?php

namespace App\Http\Controllers\SuperAdmin;

use App\Exports\SuperAdmin\DoctorMainCategoriesExport;
use App\Http\Controllers\Controller;
use App\Http\Requests\SuperAdmin\DoctorMainCategories\CreateRequest;
use App\Http\Requests\ImportRequest;
use App\Imports\SuperAdmin\DoctorMainCategoriesImport;
use App\Models\MaintenanceSetting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Maatwebsite\Excel\Facades\Excel;

class MaintenanceSettingsController extends Controller
{
   

    /*********View Edit Form of MaintenanceSetting  ***********/
    public function edit()
    {
        $maintenance_setting = MaintenanceSetting::first();
        return view('super_admins.maintenance_settings.edit', compact('maintenance_setting'));
    }

    /*********Update MaintenanceSetting  ***********/
    public function update(CreateRequest $request)
    {
        // dd($request->all());
        $maintenance_setting = MaintenanceSetting::first();
        $data = $request->all();
        try {
            DB::beginTransaction();
            if (!$request->is_active) {
                $data['is_active'] = 0;
            }
            if (!$request->is_datetime) {
                $data['is_datetime'] = 0;
            }


            
            if ($request->image) {
                $data['image'] = uploadCroppedFile($request,'image','maintenance_settings',$maintenance_setting->image);
            } else {
                $data['image'] = $maintenance_setting->image;
            }
            if ($request->icon) {
                $data['icon'] = uploadCroppedFile($request,'icon','maintenance_settings',$maintenance_setting->icon);
            } else {
                $data['icon'] = $maintenance_setting->icon;
            }
            if($data['is_active']==1){
                Artisan::call('down');
            }else{
                Artisan::call('up');
            }
            // dd($data);
            $maintenance_setting->update($data);
            $maintenance_setting = MaintenanceSetting::find($maintenance_setting->id);
            $slug = Str::slug($maintenance_setting->name . ' ' . $maintenance_setting->id, '-');
            $maintenance_setting->update([
                'slug' => $slug
            ]);
            DB::commit();
        } catch (\Exception $e) {
            DB::rollback();
            return redirect()->route('super_admin.maintenance_settings.edit')->with('message', 'Something Went Wrong')->with('message_type', 'error');
        }
        return redirect()->route('super_admin.maintenance_settings.edit')->with('message', 'MaintenanceSetting Updated Successfully')->with('message_type', 'success');
    }
}
