<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Translatable\HasTranslations;

class MaintenanceSetting extends Model
{
    use HasFactory, SoftDeletes , HasTranslations;
    protected $table = "maintenance_settings";
    public $translatable = ['name','description'];
    protected $fillable = ['name', 'description', 'slug','icon', 'image', 'is_active','is_datetime', 'end_date','end_time','deleted_at'];


    public function scopeWithAll($query)
    {
        return $query;
    }
    public function scopeWithChildrens($query)
    {
        return $query;
    }
    public function scopeActive($query)
    {
        return $query->where('is_active', 1);
    }
}
