<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    @php
        $site_title = App\Models\GeneralSetting::where('name', 'site_title')->first();
        $site_logo = App\Models\GeneralSetting::where('name', 'favicon')->first();
    $is_ai_chatbot_enable = App\Models\GeneralSetting::where('name', 'is_ai_chatbot_enable')->first();

        $google_map_key = App\Models\GeneralSetting::where('name', 'google_map_key')->first();
        $favicon = App\Models\GeneralSetting::where('name', 'favicon')->first();

        $meta_description = App\Models\GeneralSetting::where('name', 'meta_description')->first();
    $seo_title = App\Models\GeneralSetting::where('name', 'seo_title')->first();
    $social_description = App\Models\GeneralSetting::where('name','social_description')->first();
    $seo_meta_keywords = App\Models\GeneralSetting::where('name','meta_keywords')->first();
    $keywords = $seo_meta_keywords && $seo_meta_keywords->value 
                ? implode(', ', json_decode($seo_meta_keywords->value, true)) 
                : 'careconnect, keywords, for, site';
    @endphp
    <title>{{ $site_title && $site_title->value ? $site_title->value : config('app.name', 'Admin') }}</title>
    {{-- <link rel="icon" type="image/x-icon" href="{{ asset('favicon.png') }}"> --}}

    <link rel="icon" href="{{ $favicon && isset($favicon->value) ? asset($favicon->value) . '?v=' . time() : asset('images/favicon.png') . '?v=' . time() }}" />


    {{-- SEO --}}

    <meta name="keywords" content="{{ $keywords }}">
    <meta name="description" content="{{ $meta_description && $meta_description->value ? $meta_description->value : 'CareConnect description for the site.' }}">
    {{-- <meta name="keywords" content="{{ $seo_meta_keywords && $seo_meta_keywords->value ? $seo_meta_keywords->value : 'CareConnect, keywords, for, site' }}"> --}}
    <meta property="og:title" content="{{ $seo_title && $seo_title->value ? $seo_title->value : config('app.name', 'Admin') }}">
    <meta property="og:description" content="{{ $social_description && $social_description->value ? $social_description->value : 'CareConnect social media description for the site.' }}">
    <meta property="og:image" content="{{ $favicon && isset($favicon->value) ? asset($favicon->value) . '?v=' . time() : asset('images/favicon.png') }}">
    <meta property="og:url" content="{{ url()->current() }}">

    <!-- Fonts -->
    {{-- <link rel="stylesheet" href="https://fonts.bunny.net/css2?family=Nunito:wght@400;600;700&display=swap"> --}}

    <link href="https://assets.calendly.com/assets/external/widget.css" rel="stylesheet">
    <script src="https://assets.calendly.com/assets/external/widget.js" async></script>
    {{-- @if(config('app.env') == 'local')
        @routes
    @endif --}}
    <script>
        window.Laravel = {
            env: @json(config('app.env'))
        };
    </script>
    @vite('resources/js/app.js')
    @inertiaHead
    @vite('resources/js/app.js')
    @inertiaHead
    {{-- <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyC_1C7zotk5_GrthrJ-cN64xTL-VrmFZpo&libraries=places"></script> --}}
    <script src="https://maps.googleapis.com/maps/api/js?key={{ $google_map_key ? $google_map_key->value : '' }}&libraries=places"></script>
    </script>    
    </script>




</head>

<body class="font-sans antialiased">
    @inertia

    @include('colors')
    @if ($is_ai_chatbot_enable->value == 1)

    <script>
        var botmanWidget = {
            title: '{{ $site_title && $site_title->value ? $site_title->value : config('app.name', 'Admin') }}',
            aboutText: 'Developed By Hexathemes',
            mainColor: '#0A93E2',
            aboutLink: 'https://careconnect-demo.hexathemes.com/',
            bubbleBackground: '#0A93E2',
            bubbleAvatarUrl: '{{ $site_logo && $site_logo->value ? $site_logo->value : null }}',
            introMessage: "✋ Hello! Welcome to <b>{{ $site_title->value }}</b>. How can I assist you today with your medical needs?"
        };
    </script>

    <script src='https://cdn.jsdelivr.net/npm/botman-web-widget@0/build/js/widget.js'></script>

@else
    <script type="text/javascript" src="https://chatterpal.me/build/js/chatpal.js?8.3"
        integrity="sha384-+YIWcPZjPZYuhrEm13vJJg76TIO/g7y5B14VE35zhQdrojfD9dPemo7q6vnH44FR" crossorigin="anonymous"
        data-cfasync="false"></script>
    <script>
        var chatPal = new ChatPal({
            embedId: 'RWvE8Za29KJL',
            remoteBaseUrl: 'https://chatterpal.me/',
            version: '8.3'
        });
    </script>
@endif
    <script src="https://cdn.rawgit.com/davidshimjs/qrcodejs/gh-pages/qrcode.min.js"></script>
    <script src="https://js.pusher.com/beams/1.0/push-notifications-cdn.js"></script>
</body>



</html>
