<!DOCTYPE html>
<html lang="en">

<head>
    @php
    $maintenance = App\Models\MaintenanceSetting::first();
    $site_logo = App\Models\GeneralSetting::where('name', 'logo')->first();
    $site_title = App\Models\GeneralSetting::where('name', 'site_title')->first();
    @endphp
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $site_title && $site_title->value ? $site_title->value : config('app.name', 'Admin') }}</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
   
    <style>
        body {
            background-color: #f8f9fa;
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            color: #333;
            font-family: 'Arial', sans-serif;
            display: flex;
            height: 100vh;
            justify-content: center;
            align-items: center;
            text-align: center;
            flex-direction: column;
        }

        .icon {
            font-size: 5rem;
            color: #0d6efd;
            animation: pulse 1.5s infinite alternate;
        }

        @keyframes pulse {
            from {
                transform: scale(1);
            }
            to {
                transform: scale(1.1);
            }
        }

        h1 {
            font-weight: bold;
            margin-top: 20px;
        }

        .lead {
            font-size: 1.25rem;
            color: #6c757d;
        }

        .footer-text {
            margin-top: 30px;
            font-size: 0.9rem;
            color: #6c757d;
        }

        .counter {
            font-size: 1.5rem;
            font-weight: bold;
            color: #dc3545;
            margin-top: 20px;
        }
    </style>
</head>

<body>

    <div>
        <div class="icon">
            <p class="mb-0 text-muted">
                @if ($maintenance->icon)
                    <img class="mt-3" src="{{ url($maintenance->icon) }}" width="75px" height="75px" alt="{{ $maintenance->slug }}">
                @else
                    <img style="object-fit: contain" width="80px" height="80px" src="{{ $site_logo && $site_logo->value ? asset($site_logo->value) : asset('images/logo.png') }}" 
                    alt="Logo" class="brand-image">
                @endif
            </p>
        </div>
        <h1>{!! $maintenance->name !!}</h1>
        <p class="lead">{!! $maintenance->description !!}</p>
    </div>

    <div>
        @if ($maintenance->is_datetime)
            
        <span class="counter display-6" id="countdown">Loading...</span>
        @endif
    </div>

    <script>
        function startCountdown(endDate, endTime) {
            const countDownDate = new Date(`${endDate}T${endTime}`).getTime();

            function updateCountdown() {
                const now = new Date().getTime();
                const distance = countDownDate - now;

                if (distance < 0) {
                    document.getElementById("countdown").innerHTML = "Maintenance Completed!";
                    clearInterval(timer);
                    return;
                }

                const days = Math.floor(distance / (1000 * 60 * 60 * 24));
                const hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                const minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                const seconds = Math.floor((distance % (1000 * 60)) / 1000);

                document.getElementById("countdown").innerHTML = `${days} Days ${hours} Hours ${minutes} Min ${seconds} Seconds`;
            }

            const timer = setInterval(updateCountdown, 1000);
            updateCountdown();
        }

   
        startCountdown("{{ $maintenance->end_date }}", "{{ $maintenance->end_time }}");
    </script>

</body>

</html>
