@extends('super_admins.layouts.master')

@section('title')
    View Media
@endsection

@section('css')
    <!-- daterange picker -->
    <link rel="stylesheet" href="{{ asset('plugins/daterangepicker/daterangepicker.css') }}">
    <!-- Tempusdominus Bootstrap 4 -->
    <link rel="stylesheet" href="{{ asset('plugins/tempusdominus-bootstrap-4/css/tempusdominus-bootstrap-4.min.css') }}">
@endsection

@section('content')
    @if ($errors->any())
    @endif
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-4 pt-4 pt-lg-0">

                <div class="col-sm-6">
                    <h2 class="main-content-title fw-bold mb-0">Media</h2>
                    <ol class="breadcrumb float-sm-left">
                        <li class="breadcrumb-item"><a href="{{ route('super_admin.dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('super_admin.clinics.edit' , $clinic->id) }}">Clinic Profile</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('super_admin.clinic_broadcasts.index' , $clinic->id) }}">Media
                                </a></li>
                        <li class="breadcrumb-item active">
                            View Media
                        </li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <!-- left column -->
                <div class="col-md-12">
                    <!-- jquery validation -->
                    <div class="card card-secondary">
                    <div class="card-body">
                            <div class="row">
                                <div class="col-md-3 mb-3">
                                    <div class="border h-100  rounded p-3 border-light">
                                        <h6 class="fw-bold text-uppercase mb-0">Name</h6>
                                        <p class="mb-0 text-muted">{{ $clinic_broadcast->name ? $clinic_broadcast->name : '--' }}</p>
                                    </div>
                                </div>
                                <div class="col-md-3 mb-3">
                                    <div class="border h-100  rounded p-3 border-light">
                                        <h6 class="fw-bold text-uppercase mb-0">File</h6>
                                        @if($clinic_broadcast->link_type == 'internal')
                                        <p class="mb-0 text-muted"> 
                                             @if($clinic_broadcast->file_type == 'audio')
                                                    <audio controls>
                                                        <source src="{{$clinic_broadcast->audio}}" type="audio/mpeg">
                                                        Your browser does not support the audio element.
                                                    </audio>
                                                    @else
                                                    <video controls width="640" height="360">
                                                        <source src="{{$clinic_broadcast->video}}" type="video/mp4">
                                                        Your browser does not support the video element.
                                                    </video>
                                             @endif
                                        </p>
                                        @else
                                        <p class="mb-0 text-muted"> 
                                             @if($clinic_broadcast->file_url)
                                                <a href="{{$clinic_broadcast->file_url}}" >File Url</a>
                                             @endif
                                        </p>
                                        @endif
                                    </div>
                                </div>
                                <div class="col-md-3 mb-3">
                                    <div class="border h-100  rounded p-3 border-light">
                                        <h6 class="fw-bold text-uppercase mb-0">Status</h6>
                                        <p class="mb-0 text-muted">{{ $clinic_broadcast->is_active ? 'Active' : 'Inactive' }}</p>
                                    </div>
                                </div> 
                                <div class="col-md-3 mb-3">
                                    <div class="border h-100  rounded p-3 border-light">
                                        <h6 class="fw-bold text-uppercase mb-0">Created At</h6>
                                        <p class="mb-0 text-muted">{{ date_format($clinic_broadcast->created_at, 'd-m-Y') }}</p>
                                    </div>
                                </div>


                                <div class="col-md-12">
                                    <div class="border h-100  rounded p-3 border-light">
                                        <h6 class="fw-bold text-uppercase mb-0">Description</h6>
                                        <p class="mb-0 text-muted">{!! $clinic_broadcast->description !!}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                    </div>
                    <!-- /.card -->
                </div>
                <!--/.col (left) -->
                <!-- right column -->
                <div class="col-md-6">

                </div>
                <!--/.col (right) -->
            </div>
            <!-- /.row -->
        </div><!-- /.container-fluid -->
    </section>
@endsection

@section('scripts')
    <!-- date-range-picker -->
    <script src="{{ asset('plugins/moment/moment.min.js') }}"></script>
    <script src="{{ asset('plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js') }}"></script>
@endsection
